/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.cim.client.HSCFrameCIMClient;
import com.ibm.hsc.client.HSCCECClient;
import com.ibm.hsc.client.HSCClientObjectFactory;
import com.ibm.hsc.client.HSCConsoleClient;
import com.ibm.hsc.client.HSCFrameClient;
import com.ibm.hsc.command.HMCCommandUtils;
import com.ibm.hsc.command.HMCCommands;
import com.ibm.hsc.command.HMCFormatTable;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.exceptions.RequiredParameterException;
import com.ibm.hsc.frame.BPAClient;
import com.ibm.websm.diagnostics.IDebug;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;

public class HardwareInfoList
implements HMCCommands {
    private String allResources;
    private String format;
    private String frame;
    private String name;
    private String resourceType;
    private Vector frameClientVec = new Vector();
    private Hashtable resultTable;
    private HSCCECClient hcc;
    private HSCFrameClient hfc;
    private BPAClient bpaClient;
    private int[] temperatures;

    private void checkRequiredParameters() throws HSCException, RequiredParameterException {
        String string = null;
        String string2 = null;
        Object[] objectArray = null;
        if (null == this.resourceType || null == this.name && null == this.allResources) {
            objectArray = new String[]{HMCCommandUtils.RESOURCE_TYPE_PARAM + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " (" + HMCCommandUtils.NAME_PARAM + " " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "OR", "or", null) + " " + HMCCommandUtils.ALL_PARAM + ")"};
            string = new String("The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command is {0}. Please check your entry and retry the command.");
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
            throw new RequiredParameterException(string2);
        }
        if (this.resourceType.equals(HMCCommandUtils.SYSTEM_TYPE) && null == this.frame || null == this.name && null == this.allResources) {
            objectArray = new String[]{HMCCommandUtils.RESOURCE_TYPE_PARAM + ", " + HMCCommandUtils.FRAME_NAME_PARAM + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " (" + HMCCommandUtils.NAME_PARAM + " " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "OR", "or", null) + " " + HMCCommandUtils.ALL_PARAM + ")"};
            string = new String("The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command is {0}. Please check your entry and retry the command.");
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
            throw new RequiredParameterException(string2);
        }
    }

    private void validateParameterValues() throws HSCException {
        String string = null;
        String string2 = null;
        Object[] objectArray = null;
        if (!this.resourceType.equals(HMCCommandUtils.SYSTEM_TYPE) && !this.resourceType.equals(HMCCommandUtils.FRAME_TYPE)) {
            objectArray = new String[]{HSCResourceBundleUtil.getMessage("HSCCommonBundle", "RESOURCE_TYPE", "resource type", null), HSCResourceBundleUtil.getMessage("HSCCommonBundle", "RESOURCE_TYPES", "resource types", null), HMCCommandUtils.SYSTEM_TYPE + " " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.FRAME_TYPE};
            string = "The command entered contains an invalid resource type. The valid resource types are " + HMCCommandUtils.SYSTEM_TYPE + " and " + HMCCommandUtils.FRAME_TYPE + ". Please check your entry and retry the command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_GENERAL_INVALID_VALUE", string, objectArray);
            throw new HSCException(string2);
        }
    }

    private void initializeClients() throws HSCException {
        HSCClientObjectFactory hSCClientObjectFactory = null;
        HSCConsoleClient hSCConsoleClient = null;
        HSCFrameClient hSCFrameClient = null;
        InetAddress inetAddress = null;
        String string = null;
        String string2 = null;
        try {
            inetAddress = InetAddress.getLocalHost();
            string2 = inetAddress.getHostName();
        }
        catch (Exception exception) {
            throw new HSCException(exception);
        }
        hSCClientObjectFactory = HSCClientObjectFactory.getInstance(string2, null);
        if (this.resourceType.equals(HMCCommandUtils.SYSTEM_TYPE)) {
            this.hfc = hSCClientObjectFactory.createFrameClient(string2, this.frame);
            if (this.name != null) {
                this.hcc = hSCClientObjectFactory.createCECClient(this.name, false);
                if (null == this.hcc) {
                    string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "MANAGED_SYSTEM_NOT_FOUND");
                    throw new HSCException(string);
                }
            }
            if (null == this.hfc) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "FRAME_NOT_FOUND");
                throw new HSCException(string);
            }
        } else if (this.resourceType.equals(HMCCommandUtils.FRAME_TYPE)) {
            if (this.allResources != null) {
                hSCConsoleClient = hSCClientObjectFactory.createConsoleClient();
                Vector vector = hSCConsoleClient.getFrameNames();
                int n = 0;
                while (n < vector.size()) {
                    hSCFrameClient = hSCClientObjectFactory.createFrameClient(string2, (String)vector.get(n));
                    if (null == hSCFrameClient) {
                        string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "FRAME_NOT_FOUND");
                        throw new HSCException(string);
                    }
                    this.frameClientVec.add(hSCFrameClient);
                    ++n;
                }
            } else {
                this.hfc = hSCClientObjectFactory.createFrameClient(string2, this.name);
                if (null == this.hfc) {
                    string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "FRAME_NOT_FOUND");
                    throw new HSCException(string);
                }
            }
        }
    }

    public void mapParameters(HashMap hashMap) throws RequiredParameterException {
        this.allResources = (String)hashMap.get(HMCCommandUtils.ALL_PARAM);
        this.format = (String)hashMap.get(HMCCommandUtils.FORMAT_PARAM);
        this.frame = (String)hashMap.get(HMCCommandUtils.FRAME_NAME_PARAM);
        this.name = (String)hashMap.get(HMCCommandUtils.NAME_PARAM);
        this.resourceType = (String)hashMap.get(HMCCommandUtils.RESOURCE_TYPE_PARAM);
    }

    private void printAllSystemResults(Hashtable hashtable, Hashtable hashtable2) {
        HMCFormatTable hMCFormatTable = null;
        String string = null;
        Object var5_5 = null;
        String string2 = null;
        String[] stringArray = null;
        Vector vector = null;
        Vector vector2 = null;
        int n = 0;
        if (hashtable == null || hashtable.size() == 0) {
            if (null == this.format) {
                System.out.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND"));
            }
        } else {
            String[] stringArray2;
            if (null == this.format) {
                hMCFormatTable = new HMCFormatTable(2);
                stringArray = new String[]{"cec_mtms", "temperature"};
                hMCFormatTable.addEntry(stringArray);
            }
            vector = (Vector)hashtable.get("CEC_TEMPS");
            vector2 = (Vector)hashtable2.get("CEC_MTMS");
            n = vector.size() > vector2.size() ? vector2.size() : vector.size();
            int n2 = 0;
            while (n2 < n) {
                string2 = (String)vector.get(n2);
                string = (String)vector2.get(n2);
                if (null != this.format) {
                    stringArray2 = new String[2];
                    String[] stringArray3 = new String[2];
                    stringArray2[0] = "temperature";
                    stringArray3[1] = string2;
                    stringArray2[1] = "cec_mtms";
                    stringArray3[1] = string;
                    HMCCommandUtils.printFormatWithInputValues(this.format, stringArray2, stringArray3);
                } else {
                    stringArray[0] = string;
                    stringArray[1] = string2;
                    hMCFormatTable.addEntry(stringArray);
                }
                ++n2;
            }
            if (this.format == null && hMCFormatTable != null) {
                stringArray2 = hMCFormatTable.getTable();
                int n3 = 0;
                while (n3 < stringArray2.length) {
                    System.out.println(stringArray2[n3]);
                    ++n3;
                }
            }
        }
    }

    private void printSingleSystemResults(String string) {
        HMCFormatTable hMCFormatTable = null;
        Object var3_3 = null;
        String[] stringArray = null;
        Object var5_5 = null;
        boolean bl = false;
        if (string == null) {
            if (null == this.format) {
                System.out.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND"));
            }
        } else {
            String[] stringArray2;
            if (null == this.format) {
                hMCFormatTable = new HMCFormatTable(1);
                stringArray = new String[]{"temperature"};
                hMCFormatTable.addEntry(stringArray);
            }
            if (null != this.format) {
                stringArray2 = new String[1];
                String[] stringArray3 = new String[1];
                stringArray2[0] = "temperature";
                stringArray3[0] = string;
                HMCCommandUtils.printFormatWithInputValues(this.format, stringArray2, stringArray3);
            } else {
                stringArray[0] = string;
                hMCFormatTable.addEntry(stringArray);
            }
            if (this.format == null && hMCFormatTable != null) {
                stringArray2 = hMCFormatTable.getTable();
                int n = 0;
                while (n < stringArray2.length) {
                    System.out.println(stringArray2[n]);
                    ++n;
                }
            }
        }
    }

    private void printAllFrameResults(Vector vector) {
        Double d = null;
        Hashtable hashtable = null;
        Hashtable hashtable2 = null;
        HMCFormatTable hMCFormatTable = null;
        Object var6_6 = null;
        String string = null;
        String[] stringArray = null;
        Vector vector2 = null;
        if (vector == null || vector.size() == 0) {
            if (null == this.format) {
                System.out.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND"));
            }
        } else {
            hMCFormatTable = new HMCFormatTable(5);
            if (null == this.format) {
                stringArray = new String[]{"name", "power", "voltage", "current", "total_power"};
                hMCFormatTable.addEntry(stringArray);
            }
            int n = 0;
            while (n < vector.size()) {
                hashtable2 = (Hashtable)vector.get(n);
                string = (String)hashtable2.get("Name");
                vector2 = (Vector)hashtable2.get("BpaPower");
                d = (Double)hashtable2.get("BpaTotalPower");
                if (null == this.format) {
                    stringArray = new String[]{string, "", "", "", d.toString()};
                    hMCFormatTable.addEntry(stringArray);
                }
                int n2 = 0;
                while (n2 < vector2.size()) {
                    hashtable = (Hashtable)vector2.get(n2);
                    hashtable.put("BpaTotalPower", d);
                    this.constructTable(hMCFormatTable, hashtable, n == 0 && n2 == 0);
                    ++n2;
                }
                ++n;
            }
            if (this.format == null && hMCFormatTable != null) {
                String[] stringArray2 = hMCFormatTable.getTable();
                int n3 = 0;
                while (n3 < stringArray2.length) {
                    System.out.println(stringArray2[n3]);
                    ++n3;
                }
            }
        }
    }

    private void printSingleFrameResults(Hashtable hashtable) {
        Double d = null;
        Hashtable hashtable2 = null;
        HMCFormatTable hMCFormatTable = null;
        Object var5_5 = null;
        String string = null;
        String[] stringArray = null;
        Vector vector = null;
        boolean bl = false;
        if (hashtable == null) {
            if (null == this.format) {
                System.out.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND"));
            }
        } else {
            hMCFormatTable = new HMCFormatTable(5);
            string = (String)hashtable.get("Name");
            vector = (Vector)hashtable.get("BpaPower");
            d = (Double)hashtable.get("BpaTotalPower");
            if (null == this.format) {
                stringArray = new String[]{"name", "power", "voltage", "current", "total_power"};
                hMCFormatTable.addEntry(stringArray);
            }
            if (null == this.format) {
                stringArray = new String[]{string, "", "", "", d.toString()};
                hMCFormatTable.addEntry(stringArray);
            }
            int n = 0;
            while (n < vector.size()) {
                hashtable2 = (Hashtable)vector.get(n);
                hashtable2.put("BpaTotalPower", d);
                this.constructTable(hMCFormatTable, hashtable2, n == 0);
                ++n;
            }
            if (this.format == null && hMCFormatTable != null) {
                String[] stringArray2 = hMCFormatTable.getTable();
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    System.out.println(stringArray2[n2]);
                    ++n2;
                }
            }
        }
    }

    private void constructTable(HMCFormatTable hMCFormatTable, Hashtable hashtable, boolean bl) {
        Double d = null;
        Double d2 = null;
        Double d3 = null;
        Integer n = null;
        String string = null;
        Object var9_9 = null;
        String string2 = null;
        String[] stringArray = new String[]{"Ia", "Ib", "Ic"};
        String[] stringArray2 = null;
        String[] stringArray3 = new String[]{"Vab", "Vbc", "Vac"};
        Vector vector = null;
        Object var15_15 = null;
        Vector vector2 = null;
        boolean bl2 = false;
        vector = (Vector)hashtable.get("BpaCurrent");
        d = (Double)hashtable.get("BpaPower");
        d3 = (Double)hashtable.get("BpaTotalPower");
        vector2 = (Vector)hashtable.get("BpaVoltage");
        string2 = new String();
        int n2 = 0;
        while (n2 < vector2.size()) {
            n = (Integer)vector2.get(n2);
            string2 = string2 + stringArray3[n2] + "=" + n.toString();
            if (n2 + 1 < vector2.size()) {
                string2 = string2 + ",";
            }
            ++n2;
        }
        string = new String();
        int n3 = 0;
        while (n3 < vector.size()) {
            d2 = (Double)vector.get(n3);
            string = string + stringArray[n3] + "=" + d2.toString();
            if (n3 + 1 < vector.size()) {
                string = string + ",";
            }
            ++n3;
        }
        if (null != this.format) {
            String[] stringArray4 = new String[4];
            String[] stringArray5 = new String[4];
            stringArray4[0] = "power";
            stringArray5[0] = d.toString();
            stringArray4[1] = "voltage";
            stringArray5[1] = string2;
            stringArray4[2] = "current";
            stringArray5[2] = string;
            stringArray4[3] = "total_power";
            stringArray5[3] = d3.toString();
            HMCCommandUtils.printFormatWithInputValues(this.format, stringArray4, stringArray5);
        } else {
            stringArray2 = new String[]{bl ? "BPA1" : "BPA2", d.toString(), string2, string, ""};
            hMCFormatTable.addEntry(stringArray2);
        }
    }

    public void performCommand() throws HSCException, RequiredParameterException {
        this.checkRequiredParameters();
        this.validateParameterValues();
        this.initializeClients();
        if (this.resourceType.equals(HMCCommandUtils.SYSTEM_TYPE)) {
            if (null == this.allResources) {
                this.doSingleSystemList();
            } else {
                this.doAllSystemList();
            }
        } else if (null == this.allResources) {
            this.doSingleFrameList();
        } else {
            this.doAllFrameList();
        }
    }

    public void printResults() {
    }

    public void doSingleFrameList() throws HSCException {
        Object var1_1 = null;
        Hashtable hashtable = this.hfc.getEnvInfo();
        hashtable.put("Name", this.hfc.getIntName());
        this.printSingleFrameResults(hashtable);
    }

    public void doAllFrameList() throws HSCException {
        Hashtable hashtable = null;
        HSCFrameCIMClient hSCFrameCIMClient = null;
        Vector<Hashtable> vector = new Vector<Hashtable>();
        Object var4_4 = null;
        int n = 0;
        while (n < this.frameClientVec.size()) {
            hSCFrameCIMClient = (HSCFrameCIMClient)this.frameClientVec.get(n);
            hashtable = hSCFrameCIMClient.getEnvInfo();
            hashtable.put("Name", hSCFrameCIMClient.getIntName());
            vector.add(hashtable);
            ++n;
        }
        this.printAllFrameResults(vector);
    }

    public void doSingleSystemList() throws HSCException {
        int n = 0;
        String string = null;
        String string2 = this.hcc.getIntName();
        String string3 = null;
        Vector vector = null;
        Vector vector2 = null;
        Hashtable hashtable = this.hfc.getFrameInfo();
        Hashtable hashtable2 = this.hfc.getEnvInfo();
        vector2 = (Vector)hashtable2.get("CEC_TEMPS");
        vector = (Vector)hashtable.get("CEC_MTMS");
        n = vector2.size() < vector.size() ? vector2.size() : vector.size();
        int n2 = 0;
        while (n2 < n) {
            string = (String)vector.get(n2);
            if (string2.equals(string)) {
                string3 = (String)vector2.get(n2);
                break;
            }
            ++n2;
        }
        this.printSingleSystemResults(string3);
    }

    public void doAllSystemList() throws HSCException {
        Hashtable hashtable = this.hfc.getFrameInfo();
        Hashtable hashtable2 = this.hfc.getEnvInfo();
        this.printAllSystemResults(hashtable2, hashtable);
    }

    public void printHelp() {
        System.out.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "HARDWARE_INFO_LIST_HELP"));
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        HardwareInfoList hardwareInfoList = new HardwareInfoList();
        try {
            String string2 = null;
            if (0 == stringArray.length) {
                hardwareInfoList.printHelp();
            }
            int n = 0;
            while (n < stringArray.length) {
                string2 = stringArray[n];
                arrayList.add(string2);
                if (string2.equals(HMCCommandUtils.HELP_PARAM)) {
                    hardwareInfoList.printHelp();
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                HashMap hashMap = HMCCommandUtils.parseParameters(arrayList);
                hardwareInfoList.mapParameters(hashMap);
                hardwareInfoList.performCommand();
            }
        }
        catch (HSCException hSCException) {
            if (IDebug.enabled()) {
                hSCException.printStackTrace();
            }
            if ((string = hSCException.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR");
            }
            System.out.println(string);
            System.exit(1);
        }
        catch (RequiredParameterException requiredParameterException) {
            if (IDebug.enabled()) {
                requiredParameterException.printStackTrace();
            }
            if ((string = requiredParameterException.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS");
            }
            System.out.println(string);
            System.exit(1);
        }
        catch (Exception exception) {
            if (IDebug.enabled()) {
                exception.printStackTrace();
            }
            System.out.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR"));
            System.exit(1);
        }
        System.exit(0);
    }
}

